

********************************************************************************************************************************************************************
********************************************************************************************************************************************************************
*** Replication do-file for "The Power of Religion"
*** by Jeanet Sinding Bentzen and Gunes Gokmen
*** June, 2022
********************************************************************************************************************************************************************
********************************************************************************************************************************************************************


**********************************************************************************
**********************************************************************************
*** Table A.3: Stratification and beliefs in high gods, heterogeneity across major religions
**********************************************************************************
use ethno_final, clear

merge m:1 iso3 using country_final

gen religion=.
gen rel_strat=.

label var religion "Major religion dummy"
label var rel_strat "Major rel dum x Stratification"

foreach var in christiandum muslimdum buddhistdum hindusdum {
replace religion=`var'
replace rel_strat=strat*religion
reghdfe god strat religion rel_strat, a(decade v98) cl(v98)
test strat+rel_strat=0
}

********************************************************************************************************************************************************************